// Copyright 1992, 1995 by Jon Dart.  All Rights Reserved.

#ifndef _BOOK_READER_H
#define _BOOK_READER_H

#include "bookentr.h"
#include "bookdefs.h"
#include "board.h"
#include "move.h"
#include <windows.h>

class Book_Reader
{
        // provides read-only access to the opening book.

        public:

        Book_Reader(LPCSTR fileName, LPCSTR mappingName);
        // opens book file
                
        ~Book_Reader();
        // closes book file
                
        const BOOL Is_Open() const
        {
           return is_open;
        }
                
        const uint16 Head( const Board &b, enum styles style);
        // returns an index to the head of the hash chain for the
        // board position.  If style is non-zero, selects moves
        // matching a particular style.

        void Fetch( const uint16 n, Book_Entry &book_entry );
        // Fetches the nth book entry from the file.
        // Reads need not be sequential.
                
        Move Book_Reader::pick( const Board &b, uint16 node_index,
          const Book_Entry &node);
        // Randomly pick a move for board position "b". "node_index"
        // is the starting index, obtained from the Head function.
        
       protected:
               
       LPVOID pBook;
       byte *pPage;
       HANDLE hFileMapping;
       HANDLE book_file;
       BOOL is_open;
       
       Book_Header hdr;
};

#endif
